-- adapted by UberGoober from CraftSpace by SugarRay
-- this version uses a JoystickWalker dependency for controlling the player

viewer.mode=FULLSCREEN

function setup()
    scene = craft.scene()
    
    obstructionDistance = 0.2
    obstructionRadius = 0.4
    
    -- setup sun and space background
    -- skybox is a free download available at: https://www.pngegg.com/en/png-mlweb/download
    scene.sun.rotation = quat.eulerAngles(0,-90,45) 
    scene.sky.material.envMap = craft.cubeTexture(asset.SkyboxNightSky)
    
    -- all 3D models below are free to download; download addresses are listed above each model
    -- https://www.renderhub.com/shredder/space-station-kds179
    SpaceStation = scene:entity()    
    SpaceStation.model = craft.model(asset.SpaceStation2_obj)
    --    SpaceStation.model.material = craft.model(asset.documents.SpaceStation_mtl)
    Earth = scene:entity()
    -- free download: https://www.turbosquid.com/3d-models/earth-max-free/1016431
    Earth.model = craft.model(asset.Earth)
    Earth.material = craft.material(asset.builtin.Materials.Standard)
    Earth.material.map = readImage(asset.Earth_Diffuse)
    SpaceStation.position = vec3(-10,0,40)
    SpaceStation.scale = vec3(0.1,0.1,0.1)
    Earth.position = vec3(-10,-1,125)
    Earth.scale = vec3(1,1,1)
    -- add static rigid body structure to the SpaceStation & Earth model entities so can detect when astronaut is about to hit either of these structuries
    SpaceStation:add(craft.rigidbody, STATIC)
    SpaceStation:add(craft.shape.model, SpaceStation.model)
    Earth:add(craft.rigidbody, STATIC)
    Earth:add(craft.shape.model, Earth.model)    
    
    --make a player body controlled by joysticks
    --it contains a separate camera entity put inside the body 
    playerBody = joystickWalkerRig(scene:entity(), scene, asset.Z2)
    playerBody.position = vec3(46.5, 40, 46.5)
    playerBody.rig.isThirdPersonView = true
    scene.physics.gravity = vec3(0,0,0)
    playerBody.rig.contollerYInputAllowed = true
    playerBody.rig.entityWithModel.scale = vec3(1, 1, 1) * 5
    playerBody.rig.entityWithModel.position = vec3(0, -8.25, 1)
    --a control to switch between first and third person views
    parameter.boolean("thirdPersonView", true, function(value) 
        playerBody.rig.isThirdPersonView = value
    end)
end

function draw()
    scene:update(DeltaTime)    
    scene:draw()    
    if playerBody then
        playerBody.update()
        playerBody.draw()   
    end
end

